// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   uniform mat4 agk_ViewProj;
   uniform vec3 agk_CameraPos;

//--------------
// tweaks
//--------------
   uniform vec2 CloudScale[65];
   uniform vec3 CloudPosition;
   uniform vec2 CloudHeight;
   uniform vec3 CloudUv;
   uniform vec2 CloudUvScale;
   uniform vec2 NoiseUvScale;
   uniform vec2 CloudFalloff;
   uniform vec3 LightDir1;
   uniform vec3 LightDir2;

//--------------
// attributes
//--------------
    attribute vec3 position;
    attribute vec3 normal;

//--------------
// Vs Out
//--------------
    varying vec4 Vs_Tex1;
    varying vec4 Vs_Tex2;
    varying vec4 Vs_Tex3;
    varying vec4 Vs_CloudLayerT;
    varying vec4 Vs_CloudLayerB;
    varying vec4 Vs_LightLayerT;
    varying vec4 Vs_LightLayerB;
    varying vec4 Vs_BlendVec;
    varying vec3 Vs_ViewLight;

//--------------
// vertex shader
//--------------
   void main()
     {
	vec2 CloudSize=CloudScale[int(position.x)];
	vec2 CloudSz=vec2((position.y+position.z)*CloudSize.x+CloudPosition.y,(position.y-position.z)*CloudSize.x+CloudPosition.y);
	if(CloudSz.x<CloudHeight.x-CloudHeight.y || CloudSz.y>CloudHeight.x+CloudHeight.y*5.0) {
	 gl_Position=vec4(0.0,0.0,-100.0,0.0);
	}
	else {
	 vec3 NewPos=(normal*50.0*CloudSize.x)+CloudPosition;
	 if(NewPos.y<CloudHeight.x-CloudHeight.y) NewPos.y=CloudHeight.x-CloudHeight.y;
	 if(NewPos.y>CloudHeight.x+(CloudHeight.y*5.0)) NewPos.y=CloudHeight.x+(CloudHeight.y*5.0);
	 NewPos.xyz +=CloudUv;
	 Vs_Tex1.xy=(NewPos.xz/CloudUvScale);
	 Vs_Tex1.zw=(NewPos.xz/CloudUvScale)*2.0;
	 Vs_Tex2.xy=(NewPos.xz/CloudUvScale)+(0.075*-LightDir1.xz);
	 Vs_Tex2.zw=(NewPos.xy/NoiseUvScale)+CloudSize.y;
	 Vs_Tex3.xy=(NewPos.zy/NoiseUvScale)+CloudSize.y;
	 Vs_Tex3.zw=(NewPos.xz/NoiseUvScale)+CloudSize.y;
	 NewPos -=CloudUv;
	 NewPos.y -=CloudHeight.x;
	 Vs_CloudLayerT=NewPos.yyyy-vec4(0,CloudHeight.y,CloudHeight.y*2.0,CloudHeight.y*3.0);
	 Vs_CloudLayerB=Vs_CloudLayerT-CloudHeight.y;
	 Vs_CloudLayerT /=CloudHeight.y;
	 Vs_CloudLayerB /=CloudHeight.y;
	 Vs_CloudLayerB=1-Vs_CloudLayerB;
	 float CloudShift=(CloudHeight.y*2.0)-LightDir1.y;
	 NewPos.y +=CloudShift;
	 Vs_LightLayerT=NewPos.yyyy-vec4(0.0,CloudHeight.y,CloudHeight.y*2.0,CloudHeight.y*3.0);
	 Vs_LightLayerB=Vs_LightLayerT-CloudHeight.y;
	 Vs_LightLayerT /=CloudHeight.y;
 	 Vs_LightLayerB /=CloudHeight.y;
	 Vs_LightLayerB=1-Vs_LightLayerB;
	 NewPos.y -=CloudShift;
	 NewPos.y +=CloudHeight.x;
	 Vs_BlendVec.w=(NewPos.y/(CloudHeight.y*0.5))*0.75;
	 vec3 ViewVec=NewPos-agk_CameraPos;
	 NewPos.y -=length(ViewVec.xz)/(CloudFalloff.x*0.0001);
	 gl_Position=agk_ViewProj*vec4(NewPos,1.0);
	 vec3 ViewVecN=normalize(ViewVec);
	 Vs_BlendVec.xyz=pow(abs(ViewVecN),vec3(4.0,4.0,4.0));
	 Vs_BlendVec.xyz /=Vs_BlendVec.xxx+Vs_BlendVec.yyy+Vs_BlendVec.zzz;
	 Vs_ViewLight.x=pow(0.5+dot(-LightDir2,ViewVecN)*0.5,5.0);
	 Vs_ViewLight.y=1-Vs_ViewLight.x;
	 float ViewVecL=length(ViewVec);
	 Vs_ViewLight.z=1-clamp(pow(ViewVecL/CloudFalloff.x,5),0.0,1.0);
	 Vs_ViewLight.z *=clamp(ViewVecL/CloudFalloff.y,0.0,1.0);
     	}
     }
